 /*!
 * Buttons helper for envirabox
 * version: 1.1.0 (Mon, 15 Oct 2012)
 * @requires envirabox v2.0 or later
 *
 * Usage:
 *     $(".envirabox").envirabox({
 *         helpers : {
 *             buttons: {
 *                 position : 'top'
 *             }
 *         }
 *     });
 *
 */
;(function ($) {
	//Shortcut for envirabox object
	var F = $.envirabox;

	//Add helper object
	F.helpers.buttons = {
		defaults : {
			skipSingle : false, // disables if gallery contains single image
			position   : 'top', // 'top' or 'bottom'
			inline     : false,	 // if true, positioned to scroll with the content (typically set by the Comments helper)
			tpl        : '<div id="envirabox-buttons"><ul><li><a class="btnPrev" title="Previous" href="javascript:;"></a></li><li><a class="btnPlay" title="Start slideshow" href="javascript:;"></a></li><li><a class="btnNext" title="Next" href="javascript:;"></a></li><li><a class="btnToggle" title="Toggle size" href="javascript:;"></a></li><li><a class="btnClose" title="Close" href="javascript:;"></a></li></ul></div>'
		},

		list : null,
		buttons: null,

		beforeLoad: function (opts, obj) {
			var margin = [0,0,0,0];
			//Remove self if gallery do not have at least two items

			if (opts.skipSingle && obj.group.length < 2) {
				obj.helpers.buttons = false;
				obj.closeBtn = true;

				return;
			}

			//Increase top margin to give space for buttons
			margin[ opts.position === 'bottom' ? 2 : 0 ] += 30;

			$.extend(obj.margin, {
				'buttons': margin
			});

			// If both buttons and thumbnails are set to display at the top, add a CSS class to thumbnails to adjust their position.
			if ( obj.helpers.thumbs != undefined && opts.position == 'top' && obj.helpers.thumbs.position == 'top' ) {
				obj.helpers.thumbs.position = 'top has-other-content';
			}

			// If both buttons and thumbnails are set to display at the bottom, add a CSS class to thumbnails to adjust their position.
			if ( obj.helpers.thumbs != undefined && opts.position == 'bottom' && obj.helpers.thumbs.position == 'bottom' ) {
				obj.helpers.thumbs.position = 'bottom has-other-content';
			}
		},

		onPlayStart: function () {
			if (this.buttons) {
				this.buttons.play.attr('title', 'Pause slideshow').addClass('btnPlayOn');
			}
		},

		onPlayEnd: function () {
			if (this.buttons) {
				this.buttons.play.attr('title', 'Start slideshow').removeClass('btnPlayOn');
			}
		},

		afterShow: function (opts, obj) {
			var buttons = this.buttons;

			if (!buttons) {
				this.list = $(opts.tpl).addClass(opts.position).appendTo('body');

				// If set to inline, add a class now
				if ( opts.inline ) {
					this.list.addClass( 'inline' );
				}

				buttons = {
					prev   : this.list.find('.btnPrev').on('click touchstart', F.prev ),
					next   : this.list.find('.btnNext').on('click touchstart', F.next ),
					play   : this.list.find('.btnPlay').on('click touchstart', F.play ),
					toggle : this.list.find('.btnToggle').on('click touchstart', F.toggle ),
					close  : this.list.find('.btnClose').on('click touchstart', F.close )
				}
			}

			//Prev
			if (obj.index > 0 || obj.loop) {
				buttons.prev.removeClass('btnDisabled');
			} else {
				buttons.prev.addClass('btnDisabled');
			}

			//Next / Play
			if (obj.loop || obj.index < obj.group.length - 1) {
				buttons.next.removeClass('btnDisabled');
				buttons.play.removeClass('btnDisabled');

			} else {
				buttons.next.addClass('btnDisabled');
				buttons.play.addClass('btnDisabled');
			}

			this.buttons = buttons;

			this.onUpdate(opts, obj);
		},

		onUpdate: function (opts, obj) {
			var toggle;

			if (!this.buttons) {
				return;
			}

			toggle = this.buttons.toggle.removeClass('btnDisabled btnToggleOn');

			//Size toggle button
			if (obj.canShrink) {
				toggle.addClass('btnToggleOn');

			} else if (!obj.canExpand) {
				toggle.addClass('btnDisabled');
			}
		},

		beforeClose: function () {
			if (this.list) {
				this.list.remove();
			}

			this.list    = null;
			this.buttons = null;
		}
	};

}(jQuery));